Imports attach_invoice.DynaPDF

Module Module1

   ' Error callback function.
   ' If the function name should not appear at the beginning of the error message then set
   ' the flag emNoFuncNames (pdf.SetErrorMode(TErrMode.emNoFuncNames)).
   Private Function PDFError(ByVal Data As IntPtr, ByVal ErrCode As Integer, ByVal ErrMessage As IntPtr, ByVal ErrType As Integer) As Integer
      Console.Write("{0} + chr(10)", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage))
      Return 0 ' We try to continue if an error occurrs. Any other return value breaks processing.
   End Function

   Sub Main()
      Try

         Dim pdf As CPDF = New CPDF()
         ' You can either use events or declare a callback function. In this example we use a callback function
         pdf.SetOnErrorProc(AddressOf PDFError)
         pdf.CreateNewPDF(Nothing) ' The ouput file is opened later

         Dim outFile As String = System.IO.Directory.GetCurrentDirectory() + "\out.pdf"

         ' Set the license key here if you have one
         ' pdf.SetLicenseKey("");

         ' We assume that the pdf invoice is already a valid PDF/A 3 file in this example.

         pdf.SetImportFlags(TImportFlags.ifImportAsPage Or TImportFlags.ifImportAll)
         pdf.OpenImportFile("../../../../test_files/test_invoice.pdf", TPwdType.ptOpen, Nothing)

         pdf.ImportPDFFile(1, 1.0, 1.0)

         Dim ef As Integer = pdf.AttachFile("../../../../test_files/factur-x.xml", "EN 16931 compliant invoice", False)
         pdf.AssociateEmbFile(TAFDestObject.adCatalog, -1, TAFRelationship.arAlternative, ef)

         'Note that ZUGFeRD 2.1 or higher and FacturX is identically defined in PDF. Therefore, both formats share
         'the same version constants. Note also that the profiles Minimum, Basic, and Basic WL are not fully EN 16931
         'compliant and hence cannot be used to create e-invoices.
         pdf.SetPDFVersion(TPDFVersion.pvFacturX_Comfort)

         ' No fatal error occurred?
         If pdf.HaveOpenDoc() Then
            ' OK, now we can open the output file.
            If Not pdf.OpenOutputFile(outFile) Then Return
            If pdf.CloseFile() Then
               Console.Write("PDF file ""{0}"" successfully created!" + Chr(10), outFile)
               Dim p As System.Diagnostics.Process = New System.Diagnostics.Process()
               p.StartInfo.FileName = outFile
               p.Start()
            End If
         End If
      Catch e As Exception
         Console.Write(e.Message + Chr(10))
         Console.Read()
      End Try
   End Sub

End Module
